
const { createServer } = require('http');
const next = require('next');

const port = process.env.PORT || 3000;
const dev = false;
const app = next({ dev, conf: { distDir: '.next' } });
const handle = app.getRequestHandler();

app.prepare().then(() => {
  createServer((req, res) => handle(req, res)).listen(port, () => {
    console.log('> Ready on port', port);
  });
});
